# Testing and dependency injection

## Outline

### Objective

* Bridge Adapter for CRUD in both backend and front end
* building a REST API
* consuming the API from the front end


### Technologies used

* Javascript
* MongoDB
* Mocha

### Design Patterns

* Adapter
* Bridge

### What we will do

* We will write code that simulates the Javascript an event loop
* We will Apply Basic CRUD to a Database
* We will then apply various queries to get accustomed to thinking in parallel


## Session

In this session we build an adapter based on [js-data](http://www.js-data.io/v3.0/docs/home)'s implementation

Reason for when we use an adapter
Building an adapter

Using a Bridge to ease the switching of our adapter.


#Assignment


-  (5 points) a `data-Indexdb-adapter`  (you can use something like localForge)
-  (5 points) a `data-http-adapter` (you can use axios for sending requests)

#### The `data-http-adapter` works as follows

when creating it you must configure it with it’s baseURL

new HTTPAdapter({baseUrl:‘localhost:8000/api’})

when calling `create('tableName', data)`
send a `POST` request to `'api/table-name'` with body data
return a promise that resolves to the created record with its id

when calling `find(‘tableName’, 1)
send a `GET` request to `'localhost:8000/api/table-name/1`
return a promise that resolves to the found record

when calling `findAll(‘tableName’, {title: ‘happy’})
send a `GET` request to `'localhost:8000/api/table-name?title=happy'`
return a promise that resolves to an array of values found

when calling `find(‘tableName’, {title:‘happy’})
send a `GET` request to `'localhost:8000/api/table-name?title=happy&limi=1'`
but the server I deployed does not support this query

when calling `update(‘tableName’, 2, data)
send a `PUT` request to `'localhost:8000/api/table-name/2` with body equal to data
return a promise that resolves to the updated recrod

when calling `delete(‘tableName’, 2,)
send a `DELETE` request to `'localhost:8000/api/table-name/2`
return a promise that resolves to nothing

And so on

# Bonus tasks I would like you to implement

##  (5 points) `data-mongodb-adapter.js` for the 7.1.server (use mongodb package)

```
Similar to how the current server data-nedb-adapter works by taking a basePath for where to store the data
The data-mongodb-adapter will need to take the link to the database it needs to connect to
see the mongodb documentation for how to use (google how to do stuff)
```

[how to install mongodb for ubuntu](https://docs.mongodb.com/manual/tutorial/install-mongodb-on-ubuntu/)
[how to install mongodb for mac](https://docs.mongodb.com/manual/tutorial/install-mongodb-on-os-x/)
[mongodb node reference guide](http://mongodb.github.io/node-mongodb-native/2.2/)
[mongodb node api](http://mongodb.github.io/node-mongodb-native/2.2/api/)

## (5 points) data-cache-adapter that combines both the indexdb and http adapter

The way the `data-cache-adapter.js` works as follows

```
- When creating it you must set a cache timeout (default to 1 day from the time of update/creation).
- when creating, updating, or deleting you will call both the indexdb-adapter as well as http-adapter, however you will add an extra field to the data stored in the indexdb-adapter called `__lastUpdateDate` that is set to the current time `Date.now()`
- when calling find you should check
  1. first check using the indexdb-adapter wether the data already exists
  2. if yes then check wether the `__lastUpdateDate` has not exceeded the cacheTimeout time
  3. if date was not found or if data is found but is out of date; then call the find of the http-adapter and request the data, after you receives the data the adapter must update the indexdb adapter cache with the found data and update it’s `__lastUpdated` Filed to `Date.now()`.
```

The due date for the *one* of the bonus tasks is next session
The other is the session after.

Extending the react tasks I will grant *4 points* for extending the current todo app 7.1.client app functionality by adding an edit button button for both the todolist and todoitem components that toggles the list title or item text into an input filed for users to update the existing list.
